#include "bipartite.hpp"
#include <stack>
#include <iostream>
#include <unordered_map>
using namespace std;

BipartiteGraph::BipartiteGraph(int numNodes) : n(numNodes), maxMatching(0) {
    BP.resize(n);
}

vector<vector<int>> BipartiteGraph::convertDAGtoBP(const vector<vector<int>>& DAG, const vector<pair<int, int>>& edges) {
    BP.assign(n, vector<int>());
    for (const auto& p : edges) {
        int u = p.first;
        int v = p.second;
        BP[u].push_back(v);
    }
    return BP;
}


bool BipartiteGraph::augmentingPath(int start, vector<bool>& visited) {
    stack<int> s;
    unordered_map<int, int> parent;
    s.push(start);
    parent[start] = -1;
    while (!s.empty()) {
        int u = s.top();
        s.pop();
        for (int v : BP[u]) {
            if (visited[v]) continue;
            visited[v] = true;
            if (inv_match[v] == -1) {
                int cur_v = v;
                int cur_u = u;
                while (cur_u != -1) {
                    int next_v = match[cur_u];
                    match[cur_u] = cur_v;
                    inv_match[cur_v] = cur_u;
                    cur_u = parent[cur_u];
                    cur_v = next_v;
                }
                return true;
            }
            else {
                int next_u = inv_match[v];
                parent[next_u] = u;
                s.push(next_u);
            }
        }
    }

    return false;
}

int BipartiteGraph::Match() {

    match.assign(n, -1);
    inv_match.assign(n, -1);
    maxMatching = 0;

    for (int u = 0; u < n; ++u) {
        vector<bool> visited(n, false);
        if (augmentingPath(u, visited)) {
            maxMatching++;
        }
    }
    return maxMatching;
}


const vector<int>& BipartiteGraph::getMatch() const {
    return match;
}
const vector<int>& BipartiteGraph::getInvMatch() const {
    return inv_match;
}
int BipartiteGraph::getMaxMatching() const {
    return maxMatching;
}
